# MariaDB

## Introduction

**MariaDB** is an open source relational database management system (RDBMS), developed as a fork of MySQL. It was initiated by the original MySQL developers after Oracle acquired MySQL AB in 2010, with the goal of ensuring ongoing open development and community-driven governance. MariaDB aims for compatibility with MySQL, while introducing optimizations, new storage engines, and features tailored for high performance, scalability, and security.

## Key Technical Features

- **ACID Compliance**: Full support for transactions, rollback, and crash recovery.
- **Storage Engines**: Native support for multiple engines (InnoDB, Aria, MyRocks, ColumnStore, TokuDB, Spider, and more).
- **Replication**: Supports asynchronous, semi-synchronous, and multi-source replication. Includes advanced Galera Cluster integration for synchronous multi-master replication.
- **JSON and GIS**: Native JSON functions and spatial extensions.
- **Thread Pooling**: Built-in thread pool for better concurrency management.
- **Encryption**: Tablespace, redo/undo log, and client/server encryption.
- **Optimizer**: Enhanced query optimizer for complex workloads.
- **Extensibility**: Plugin API for custom storage engines, functions, and extensions.
- **High Availability**: Automatic failover, online DDL, and backup tools.
- **Compatibility**: CLI tools (`mysql`, `mysqldump`, etc.) and wire protocol compatible with MySQL for most scenarios.

## Performance and Scalability

- Enhanced support for high connection counts and massive datasets.
- Index condition pushdown, subquery optimizations, and parallel replication.
- Columnar and row-based storage for OLAP and OLTP workloads.
- Partitioning and sharding via storage engines and third-party solutions.

---

# MariaDB vs. MySQL

## Major Differences

- **Licensing and Development**:  
  - MariaDB is fully GPL (open source), with community-driven governance.
  - MySQL, under Oracle, offers an open core, but several features are exclusive to the commercial (Enterprise) edition.

- **Feature Set**:  
  - MariaDB includes more storage engines by default (Aria, ColumnStore, Spider, MyRocks, etc.).
  - MariaDB releases new features more rapidly and accepts community contributions more freely.
  - MySQL focuses on stability, but is slower to introduce new community features.

- **Replication**:  
  - MariaDB has integrated Galera Cluster and additional replication modes.
  - MySQL’s Group Replication and InnoDB Cluster are enterprise-focused.

- **Syntax & Compatibility**:  
  - Until v5.5, MariaDB and MySQL are drop-in compatible.  
  - Post v10.1 (MariaDB) and v5.7+ (MySQL), feature divergence increases (e.g., JSON, roles, optimizer improvements).
  - Some features (e.g., temporal tables, certain SQL modes) are implemented differently or are unique to each.

- **Performance**:  
  - MariaDB may outperform MySQL in some workloads due to optimizer and engine choices.
  - MySQL Enterprise can outperform MariaDB in certain high-end scenarios, especially with Oracle’s commercial enhancements.

- **Tooling & Ecosystem**:  
  - Some tools and plugins target only MySQL (especially Oracle’s commercial ecosystem).
  - MariaDB maintains compatibility with most MySQL tools, but feature lag or incompatibility may occur for newer features.

---

## Pros and Cons of MariaDB Compared to MySQL

### Pros

- Fully open source (no proprietary/commercial-only features).
- Broader selection of storage engines and plugins.
- Faster adoption of community patches and new features.
- Transparent, community-driven development process.
- Integrated Galera Cluster for multi-master replication.
- Superior performance in certain OLAP/OLTP mixed workloads.

### Cons

- Increasing incompatibility with latest MySQL features (especially after MySQL 8.0).
- Some enterprise tools/integrations (e.g., Oracle-specific plugins, enterprise backup) are not available or not fully compatible.
- Slightly smaller market share and ecosystem in corporate environments.
- Possible migration/compatibility issues for applications leveraging MySQL 8.0+ features.

---

## References

- [MariaDB Official Site](https://mariadb.org/)
- [MariaDB Knowledge Base](https://mariadb.com/kb/en/documentation/)
- [MariaDB vs MySQL Compatibility](https://mariadb.com/kb/en/mariadb-vs-mysql-compatibility/)
- [MySQL Official Site](https://www.mysql.com/)

