## SFTPGo

SFTPGo is an open-source, event-driven file transfer solution supporting SFTP, FTP/S, HTTP/S, and WebDAV. Designed for flexibility and scalability, it lets you leverage both local and cloud storage backends to exchange and store files securely and efficiently. :contentReference[oaicite:0]{index=0}

### Key Features

- **Multi-Protocol Support**  
  SFTPGo handles SFTP, FTP/S, WebDAV, and HTTP/S, giving you a single server for all your file-transfer needs. :contentReference[oaicite:1]{index=1}

- **Flexible Storage Backends**  
  Integrates with local filesystems (including encrypted local FS), S3-compatible Object Storage, Google Cloud Storage, Azure Blob Storage, and even other SFTP servers. :contentReference[oaicite:2]{index=2}

- **Virtual Folders**  
  Define per-user virtual folders mapping to any supported backend—private or shared—with configurable quotas for each user. :contentReference[oaicite:3]{index=3}

- **Event-Driven Hooks & Custom Actions**  
  Automate workflows via hooks (pre/post-upload, download, delete, rename, etc.) and custom commands or HTTP callbacks on SSH commands and user lifecycle events. :contentReference[oaicite:4]{index=4}

- **Data Providers**  
  Store users and configuration in SQLite, MySQL, PostgreSQL, CockroachDB, Bolt (pure-Go key/value store), or in-memory providers. :contentReference[oaicite:5]{index=5}

- **WebAdmin & WebClient Interfaces**  
  A WebAdmin UI for administrators and a WebClient UI for end users—manage accounts, browse files, set up two-factor authentication, and create secure, expiring share links. :contentReference[oaicite:6]{index=6}

- **Advanced Administration**  
  Role-based access control, searchable/exportable audit logs, and a Terraform provider for seamless infrastructure-as-code integration. :contentReference[oaicite:7]{index=7}

- **Security Features**  
  Built-in two-factor authentication, IP whitelisting, rate limiting, and OpenID Connect support for SSO integration. :contentReference[oaicite:8]{index=8}

- **Cross-Platform Compatibility**  
  Runs on Linux, Windows, and macOS, fitting into diverse environments with ease. :contentReference[oaicite:9]{index=9}

- **Open Source & AGPL-3.0 Licensed**  
  Free to use and modify, with optional commercial support plans available. :contentReference[oaicite:10]{index=10}