# PocketBase

## What is PocketBase?

PocketBase is an open-source backend platform distributed as a single executable. It provides a complete backend solution out of the box, including a built-in SQLite database, authentication system, file storage, real-time subscriptions, and a RESTful API. PocketBase is designed to be lightweight, fast, and easy to deploy, making it ideal for small to medium applications, prototypes, and internal tools.

---

## Key Features
- Built-in SQLite database with automatic migrations and schema management
- Authentication and authorization with support for users, admins, and OAuth providers
- REST API and real-time subscriptions for building reactive applications
- Integrated file storage with access control and validation
- Admin dashboard for managing data, users, and application settings

---

## Architecture

PocketBase follows a simple and efficient architecture centered around a single binary. It embeds the database, API server, authentication logic, and admin UI into one executable, reducing operational complexity. The platform exposes a RESTful API and real-time endpoints, while SQLite serves as the persistent storage layer. This design allows PocketBase to run consistently across different environments with minimal configuration.

---

## Resources and Documentation
- [Official Site](https://pocketbase.io/)
- [Documentation and Support](https://pocketbase.io/docs/)
- [Repository](https://github.com/pocketbase/pocketbase)