# Redis

## What is Redis

Redis (REmote DIctionary Server) is an in-memory, open-source database that functions as a key-value data structure. It is widely used for applications that require high performance, low latency, and real-time operations.

## Main Features

- **In-Memory Storage:** All data is kept in RAM, ensuring fast access.
- **Diverse Data Structures:** Supports strings, lists, sets, hashes, sorted sets, bitmaps, hyperloglogs, and streams.
- **Optional Persistence:** Allows data persistence to disk through snapshots (RDB) or append-only logs (AOF).
- **Replication and High Availability:** Supports master-slave replication, automatic failover, and clustering for horizontal scalability.
- **Transactions and Scripts:** Offers support for atomic transactions and Lua scripts for complex operations.
- **Pub/Sub:** Implements the publish/subscribe model for real-time communication between different parts of the application.

## Use Cases

- **Data Caching:** Reduces load on primary databases by storing frequently accessed data.
- **User Sessions:** Efficiently manages user sessions in web applications.
- **Queues and Messaging Systems:** Implements task queues and real-time messaging systems.
- **Counters and Rankings:** Calculates real-time counts and maintains updated rankings.
- **Temporary Data Storage:** Stores temporary data for operations that do not require permanent persistence.

## Advantages

- **High Performance:** Extremely fast operations due to in-memory storage.
- **Flexibility:** Support for various data structures allows solving a wide range of problems.
- **Scalability:** Easy to scale horizontally with clustering and replication.
- **Simplicity:** Simple command-based interface that facilitates integration with different programming languages.
- **Active Community:** Large ecosystem of tools, libraries, and community support.

## How It Works

Redis operates as a server that listens for client connections and processes commands sent by them. Data is stored in data structures in memory, and depending on the configuration, can be persisted to disk for recovery in case of failures. Communication with Redis is generally done through protocols like RESP (REdis Serialization Protocol).

## Basic Command Examples

- `SET key value` – Sets the value of a key.
- `GET key` – Gets the value of a key.
- `DEL key` – Removes a key.
- `LPUSH list value` – Inserts a value at the beginning of a list.
- `SADD set value` – Adds a value to a set.
- `HSET hash field value` – Sets a field in a hash.
- `SUBSCRIBE channel` – Subscribes to a channel to receive messages via Pub/Sub.