# vi:filetype=perl

use lib 'lib';
use Test::Nginx::LWP;

plan tests => repeat_each() * 2 * blocks();
$ENV{TEST_NGINX_BACKENDS_PORT} ||= "www.taobao.com:80";
no_root_location();

#no_diff;

run_tests();

__DATA__

=== TEST 1: the "fix string substitution" command
--- http_config

    upstream backends {
        server $TEST_NGINX_BACKENDS_PORT;
    }

--- config

    location / {
        subs_filter 'taobao.com' 'yaoweibin';
        proxy_pass http://yaoweibin.net:8080/test/subs/taobao.htm;
    }
--- request
    GET /
--- response_body_unlike: ^(.*)taobao\.com(.*)$
